#!/usr/bin/python3
#Author: V.Shumeyko UserGate Company
import requests;
import json;
import random;
import logging;
import urllib3;
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning);
from netifaces import interfaces, ifaddresses, AF_INET
logging.basicConfig(filename='logout.txt', filemode='w', level=logging.INFO);
urlLogout = 'https://auth.captive:8043/cp_api/logout'; #URL обращения к REST API
DEBUG = True; # Включить/выключить отладочные сообщения в логах

#######################################################################

#Функция выполнения запросов
def getRequest(method = 'get', url = '', data = []):
	log = logging.getLogger('Request');
	result = '';
	if DEBUG: log.info(f"method={method}, url={url}, data={data}");
	try:
		if method == 'get':
			if DEBUG: log.info(f"Попытка GET запроса");	 
			result = requests.get(url);
		else:
			if DEBUG: log.info(f"Попытка POST запроса");	 
			result = requests.post(url,json=data, verify=False);
	except Exception as e:
		log.exception('Ошибка выполнения запроса');
		ERROR_=True;
		return False;
	else:
		if DEBUG: log.info(f"Request: {result}");
		if DEBUG: log.info(f"Request Body: {result.text}");
		if result.text.find('true') < 0:
			return False;
		else :
			return result;	

def getIp():
	log = logging.getLogger('getterIp');
	try:
		int = interfaces();
		addresses = list();
		int.remove('lo');
		for ifaceName in int:
			address = [i['addr'] for i in ifaddresses(ifaceName).setdefault(AF_INET, [{'addr':'No IP addr'}] )];
			addresses.append(address);
	except Exception as e:
		log.exception('Ошибка получения IP адресов');
		ERROR_=True;
		return False;
	else:
		if DEBUG: log.info(f"Найдены Ip Адреса: {addresses}");
		return addresses;

log = logging.getLogger('General');
ERROR_ = False;
try:
	int = getIp();
	result = False;
	for ip in int:
		result = getRequest('post',urlLogout,ip);
		if result: break;
	if result: 
		log.info("Процедура Logout завершена успешно");
	else:
		log.error("Процедура Logout завершена неудачно");
		ERROR_ = True;

except Exception as e:
	ERROR_ = True;
	log.exception('Ошибка процедуры Logout');
finally:
	if ERROR_:
		log.info('Скрипт завершен с ошибкой');
	else:
		log.info('Успешное завершение скрипта');



	






