#!/usr/bin/python3
#Author: V.Shumeyko UserGate Company
import requests;
import json;
import random;
import logging;
import urllib3;
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning);
from urllib.parse import urlparse, parse_qs;
logging.basicConfig(filename='login.txt', filemode='w', level=logging.INFO);
###################################################################
###### Для авторизации необходимо передать следующие параметры: ###
###################################################################
# login — user login name
# password — user password
# agent — USER_AGENT string
# token — security token that UTM server generates when it needs to display Captive Portal
# cookie — unique cookie string that identifies user device
# remember — if true return authentication cookie
login = 'user';
password = '123';
agent = 'Script';
#token - получаем от UG UTM вводить не надо
#cookie формируем рандомно, функцией genCookie()
remember = True; #Разрешить браузерам запомнить авторизацию
DEBUG = True; # Включить/выключить отладочные сообщения в логах
urlVerification = 'http://cbr.ru'; # URL для начального обращения к Captive порталу(может быть любым существующим в Internet)
urlLogin = 'http://auth.captive:4040/web_api/v1.captiveportal.user.login'; #URL обращения к REST API

#######################################################################

#Функция выполнения запросов
def getRequest(method = 'get', url = '', data = []):
	log = logging.getLogger('Request');
	result = '';
	if DEBUG: log.info(f"method={method}, url={url}, data={data}");
	try:
		if method == 'get':
			if DEBUG: log.info(f"Попытка GET запроса");	 
			result = requests.get(url, verify=False);
		else:
			if DEBUG: log.info(f"Попытка POST запроса");	 
			result = requests.post(url,json=data, verify=False);
	except Exception as e:
		log.exception('Ошибка выполнения запроса');
		ERROR_=True;
		return False;
	else:
		if DEBUG: log.info(f"Request: {result}");
		#if DEBUG: log.info(f"Request: {result.text}");
		return result;	
	
	
#Функция создания имени Cookie
def genCookie(length):
	log = logging.getLogger('Generator');
	if DEBUG: log.info(f"Создаем имя для Cookie ...");
	try:
		chars = '+-/*!&$#?=@<>abcdefghijklnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
		password ='';
		for i in range(length): 
			password += random.choice(chars);
	except Exception as e:
		log.exception('Ошибка создания имени cookie');
		ERROR_ = True;
		return False;
	else:
		if DEBUG: log.info(f"Успешно");
		return password;

cookie = genCookie(12);
result = getRequest('get', urlVerification);
url = urlparse(result.url);
qs = parse_qs(url.query);
log = logging.getLogger('General');
ERROR_ = False;
log.info(f"Попытка авторизации");
try:
	token = qs['st'][0];
except Exception as e:
	ERROR_ = True;
	if e.args[0] == 'st':
		log.error('Ошибка получения токена безопасности, возможно уже авторизованы?');
	else:
		log.exception('Неизвестная ошибка');
else:
	#Формируем данные для отправки в API
	data = [login,password,agent,token,cookie,remember];
	result = getRequest('post', urlLogin, data);
	if result.json()['login'] == login:
		log.info(f"Авторизация успешно завершена");
	else:
		log.error(f"Ошибка авторизации");
		ERROR_ = True;
finally:
	if ERROR_:
		log.info('Скрипт завершен с ошибкой');
	else:
		log.info('Успешное завершение скрипта');



